/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.client;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraftforge.common.world.ForgeWorldType;
import vazkii.quark.content.world.gen.RealisticChunkGenerator;

public class RealisticWorldType
extends ForgeWorldType {
    final String name;

    public RealisticWorldType(String name, boolean large) {
        super(large ? RealisticWorldType::getChunkGeneratorBig : RealisticWorldType::getChunkGenerator);
        this.setRegistryName(new ResourceLocation("quark", name));
        this.name = name;
    }

    public String getTranslationKey() {
        return String.format("generator.%s.%s", "quark", this.name);
    }

    static ChunkGenerator getChunkGenerator(Registry<Biome> biomeRegistry, Registry<DimensionSettings> settings, long seed) {
        return new RealisticChunkGenerator((BiomeProvider)new OverworldBiomeProvider(seed, false, false, biomeRegistry), seed, () -> (DimensionSettings)settings.func_243576_d(DimensionSettings.field_242734_c));
    }

    static ChunkGenerator getChunkGeneratorBig(Registry<Biome> biomeRegistry, Registry<DimensionSettings> settings, long seed) {
        return new RealisticChunkGenerator((BiomeProvider)new OverworldBiomeProvider(seed, false, true, biomeRegistry), seed, () -> (DimensionSettings)settings.func_243576_d(DimensionSettings.field_242734_c));
    }
}

